<?php

namespace App\Models\Word;

use Illuminate\Database\Eloquent\Model;

class Word extends Model 
{

    protected $table = 'words';
    public $timestamps = true;
    protected $fillable = array('language_id', 'word', 'audio', 'definition');
    protected $visible = array('audio', 'definition');

    public function language()
    {
        return $this->belongsTo('Language');
    }

    public function translations()
    {
        return $this->hasMany('Translation', 'original_word_id');
    }

}